<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

if ( ! function_exists('add_user_meta'))
{
	function add_user_meta ($user_id,$key,$value)
	{
		$CI = get_instance();
		$CI->load->database();
		$query = $CI->db->get_where('user_meta',array('user_id'=>$user_id,'key'=>$key));
		if($query->num_rows()>0)
		{
			$CI->db->update('user_meta',array('value'=>$value),array('user_id'=>$user_id,'key'=>$key));
		}
		else
		{
			$CI->db->insert('user_meta',array('user_id'=>$user_id,'key'=>$key,'value'=>$value));
		}
	}
}

if ( ! function_exists('get_user_meta'))
{
	function get_user_meta ($user_id,$key,$default='')
	{
		$CI = get_instance();
		$CI->load->database();
		$query = $CI->db->get_where('user_meta',array('user_id'=>$user_id,'key'=>$key));
		if($query->num_rows()>0)
		{
			$row = $query->row();
			return $row->value;
		}
		else
		{
			return $default;
		}
	}
}


#-----------------

if ( ! function_exists('add_short_url'))
{
	function add_short_url ($post_id,$value)
	{
		$CI = get_instance();
		$CI->load->database();
		$query = $CI->db->get_where('media',array('media_name'=>$post_id));
		if($query->num_rows()>0)
		{
			$CI->db->update('media',array('media_url'=>$value),array('media_name'=>$post_id));
		}
		else
		{
			$CI->db->insert('media',array('media_name'=>$post_id,'media_url'=>$value));
		}
	}
}

if ( ! function_exists('get_short_url'))
{
	function get_short_url ($post_id,$default='n/a')
	{
		$CI = get_instance();
		$CI->load->database();
		$query = $CI->db->get_where('media',array('media_name'=>$post_id));

		if($query->num_rows()>0)
		{
			$row = $query->row();
			return $row->media_url;
		}
		else
		{
			return $default;
		}
	}
}

/*
if ( ! function_exists('get_post_custom_value'))
{
	function get_post_custom_value ($post_id,$key,$field,$default='n/a')
	{
		$CI = get_instance();
		$CI->load->database();
		$query = $CI->db->get_where('post_meta',array('post_id'=>$post_id,'key'=>$key));
		if($query->num_rows()>0)
		{
			$row = $query->row();
			if($row->value!='')
			{
				$val = (array)json_decode($row->value);
				return (isset($val[$field]))?$val[$field]:$default;
			}
		}
		else
		{
			return $default;
		}
	}
}
*/

if ( ! function_exists('get_featured_photo_by_id'))
{
	function get_featured_photo_by_id($img='')
	{
		if($img=='')
		return base_url('assets/admin/img/preview.jpg');
		else
		return base_url('uploads/thumbs/'.$img);
	}
}

/*
if ( ! function_exists('get_slider_photo_by_name'))
{
	function get_slider_photo_by_name($img='')
	{
		if($img=='')
		return base_url('assets/admin/img/preview.jpg');
		else
		return base_url('uploads/slider/'.$img);
	}
}


if ( ! function_exists('get_title_for_edit_by_id_lang'))
{
	function get_title_for_edit_by_id_lang($id,$lang)
	{
		$CI = get_instance();
		$CI->load->database();
		$query = $CI->db->get_where('post_meta',array('post_id'=>$id,'key'=>'title','status'=>1));
		if($query->num_rows()>0)
		{
			$row = $query->row();
			$data = ($row->value=='')?array():(array)json_decode($row->value);
			if(isset($data[$lang]) && $data[$lang]!='')
				return $data[$lang];
			else
			{
				$text = '';
				foreach ($data as $key => $value) {
					$text = $value;break;	
				}
				return $text;
			}
		}
		else
			return 'N/A';

		return $query;
	}
}

if ( ! function_exists('get_blog_data_by_lang'))
{
	function get_blog_data_by_lang($post,$column='title')
	{
		if($column=='title')
		{
			$titles = json_decode($post->title);
			$lang = get_current_lang();
			if(isset($titles->{$lang}) && $titles->{$lang}!='')
				return $titles->{$lang};
			else
				return $titles->{default_lang()};			
		}
		else
		{
			$descriptions = json_decode($post->description);
			$lang = get_current_lang();
			if(isset($descriptions->{$lang}) && $descriptions->{$lang}!='')
				return $descriptions->{$lang};
			else
				return $descriptions->{default_lang()};					
		}
	}
}

if ( ! function_exists('get_post_data_by_lang'))
{
	function get_post_data_by_lang($post,$column='title',$lang='')
	{
		if($lang=='')
			$lang = get_current_lang();

		if($column=='title')
		{
			$titles = json_decode($post->title);
			if(isset($titles->{$lang}) &&  $titles->{$lang}!='')
				return $titles->{$lang};
			else
				return (isset($titles->{default_lang()}))?$titles->{default_lang()}:'';
		}
		else
		{
			$descriptions = json_decode($post->description);
			if(isset($descriptions->{$lang}) &&  $descriptions->{$lang}!='')
				return $descriptions->{$lang};
			else
				return (isset($descriptions->{default_lang()}))?$descriptions->{default_lang()}:'';
		}
	}
}

if ( ! function_exists('get_description_for_edit_by_id_lang'))
{
	function get_description_for_edit_by_id_lang($id,$lang)
	{
		$CI = get_instance();
		$CI->load->database();
		$query = $CI->db->get_where('post_meta',array('post_id'=>$id,'key'=>'description','status'=>1));
		if($query->num_rows()>0)
		{
			$row = $query->row();
			$data = ($row->value=='')?array():(array)json_decode($row->value);
			if(isset($data[$lang]) && $data[$lang]!='')
				return $data[$lang];
			else
			{
				$text = '';
				foreach ($data as $key => $value) {
					$text = $value;break;	
				}
				return $text;
			}
		}
		else
			return 'N/A';

		return $query;
	}
}

*/

if ( ! function_exists('create_square_thumb'))
{
	function create_square_thumb($img,$dest)
	{
		$seg = explode('.',$img);
		$thumbType    = 'jpg';
		$thumbSize    = 300;
		$thumbPath    = $dest;
		$thumbQuality = 100;

		$last_index = count($seg);
		$last_index--;

		if(strcasecmp($seg[$last_index], 'jpg') == 0 || strcasecmp($seg[$last_index], 'jpeg') == 0)
		{
			if (!$full = imagecreatefromjpeg($img)) {
			    return 'error';
			}			
		}
		else if(strcasecmp($seg[$last_index], 'png') == 0)
		{
			if (!$full = imagecreatefrompng($img)) {
			    return 'error';
			}			
		}
		else if(strcasecmp($seg[$last_index], 'gif') == 0)
		{
			if (!$full = imagecreatefromgif($img)) {
			    return 'error';
			}			
		}
		 
	    $width  = imagesx($full);
	    $height = imagesy($full);
		 
	    /* work out the smaller version, setting the shortest side to the size of the thumb, constraining height/wight */
	    if ($height > $width) {
	      $divisor = $width / $thumbSize;
	    } else {
	      $divisor = $height / $thumbSize;
	    }
		 
	    $resizedWidth   = ceil($width / $divisor);
	    $resizedHeight  = ceil($height / $divisor);
		 
	    /* work out center point */
	    $thumbx = floor(($resizedWidth  - $thumbSize) / 2);
	    $thumby = floor(($resizedHeight - $thumbSize) / 2);
		 
	    /* create the small smaller version, then crop it centrally to create the thumbnail */
	    $resized  = imagecreatetruecolor($resizedWidth, $resizedHeight);
	    $thumb    = imagecreatetruecolor($thumbSize, $thumbSize);
	    imagecopyresized($resized, $full, 0, 0, 0, 0, $resizedWidth, $resizedHeight, $width, $height);
	    imagecopyresized($thumb, $resized, 0, 0, $thumbx, $thumby, $thumbSize, $thumbSize, $thumbSize, $thumbSize);
		 
		 $name = name_from_url($img);

	    imagejpeg($thumb, $thumbPath.str_replace('_large.jpg', '_thumb.jpg', $name), $thumbQuality);
	}
	
}

if ( ! function_exists('humanTiming'))
{
	function humanTiming ($time)
	{

	    $time = time() - $time; // to get the time since that moment

	    $tokens = array (
	        31536000 => 'year',
	        2592000 => 'month',
	        604800 => 'week',
	        86400 => 'day',
	        3600 => 'hour',
	        60 => 'minute',
	        1 => 'second'
	    );

	    foreach ($tokens as $unit => $text) {
	        if ($time < $unit) continue;
	        $numberOfUnits = floor($time / $unit);
	        return $numberOfUnits.' '.$text.(($numberOfUnits>1)?'s':'').' ago';
	    }

	}
}


if ( ! function_exists('social_sharing_meta_tags_for_post'))
{

	function social_sharing_meta_tags_for_post($post='')
	{

		if($post!='' && $post->num_rows()>0)
		{
			$CI = get_instance();
			$post = $post->row();
			$curr_lang = get_current_lang();
			$site_title = get_settings('site_settings','site_title','newspilot');
			$title = $post->title;

            $detail_link = post_detail_url($post);
            $featured_img = $post->media;
			$CI->load->config('webhelios');
			if($CI->config->item('use_ssl')=='yes')
			$featured_img = str_replace('http://','https://',$featured_img); #uncomment this line if you want to force 


            $description = truncate(strip_tags($post->description),100,'');
            $description = str_replace("&nbsp;", "", $description);
            $description = str_replace("'", "", $description);
            $description = str_replace('"', "", $description);

			$meta = '<meta name="twitter:card" content="summary_large_image" />'."\n".
					'<meta name="twitter:site" content="'.$site_title.'" />'."\n".
					'<meta name="twitter:title" content="'.$title.'" />'."\n".
					'<meta name="twitter:description" content="'.$description.'" />'."\n".
					'<meta name="twitter:image" content="'.$featured_img.'?'.uniqid().'" />'."\n".
					'<meta property="og:title" content="'.$title.'" />'."\n".
					'<meta property="og:site_name" content="'.$site_title.'" />'."\n".
					'<meta property="og:url" content="'.$detail_link.'" />'."\n".
                    '<meta property="og:description" content="'.$description.'" />'."\n".
					'<meta property="og:type" content="article" />'."\n".
					'<meta property="og:image" content="'.$featured_img.'" />'."\n".
					'<link rel="canonical" href="'.$detail_link.'"/>';

			if(get_settings('global_settings','fb_app_id','none')!='')
			{

				$meta .='<meta property="fb:app_id" content="'.get_settings('global_settings','fb_app_id','none').'" />';
			}

		 
		 	return $meta;
		}
		else
			return '';

	}
}

if ( ! function_exists('social_sharing_meta_tags_for_pages'))
{

	function social_sharing_meta_tags_for_pages($alias='',$title='',$meta_desc='',$key_words='')
	{

			$CI = get_instance();

			$site_title = get_settings('site_settings','site_title','newspilot');
            $url = current_url();
            $description = $meta_desc;

			$meta = '<meta name="twitter:card" content="photo" />'."\n".
					'<meta name="twitter:site" content="'.$site_title.'" />'."\n".
					'<meta property="og:title" content="'.$title.'" />'."\n".
					'<meta property="og:site_name" content="'.$site_title.'" />'."\n".
					'<meta property="og:url" content="'.$url.'" />'."\n".
                    '<meta property="og:description" content="'.$meta_desc.'" />'."\n".
					'<meta property="og:type" content="article" />'."\n".
					'<link rel="canonical" href="'.$url.'"/>'."\n".
					'<link rel="alternate" hreflang="x-default" href="'.$url.'">';

			if(get_settings('global_settings','fb_app_id','none')!='')
			{

				$meta .='<meta property="fb:app_id" content="'.get_settings('global_settings','fb_app_id','none').'" />';
			}

		 
		 	return $meta;

	}
}



if ( ! function_exists('word_limiter'))
{
    function word_limiter($str, $limit = 100, $end_char = '&#8230;')
    {
        if (trim($str) == '')
        {
            return $str;
        }

        preg_match('/^\s*+(?:\S++\s*+){1,'.(int) $limit.'}/', $str, $matches);

        if (strlen($str) == strlen($matches[0]))
        {
            $end_char = '';
        }

        return rtrim($matches[0]).$end_char;
    }
}


if ( ! function_exists('fileinfo_from_url'))
{

	function fileinfo_from_url($filePath)
	{
	 $fileParts = pathinfo($filePath);

	 if(!isset($fileParts['filename']))
	 {$fileParts['filename'] = substr($fileParts['basename'], 0, strrpos($fileParts['basename'], '.'));}
	 
	 return $fileParts;
	}
}

if ( ! function_exists('name_from_url'))
{

	function name_from_url($filePath)
	{
	 
	 $filePath = preg_replace('/\?.*/', '', $filePath);
	 $fileParts = pathinfo($filePath);
	 // print_r($fileParts);
	 // die;

	 if(!isset($fileParts['filename']))
	 {$fileParts['filename'] = substr($fileParts['basename'], 0, strrpos($fileParts['basename'], '.'));}
	
	 

	 return $fileParts['basename'];
	}
}

if ( ! function_exists('rename_if_exists'))
{
	function rename_if_exists ($name='',$counter=0)
	{
		while(1)
		{
			$seg = explode(".", $name);
			$loc = "./uploads/images/".$seg[0].'-'.$counter.'.'.$seg[1];

			if(!file_exists($loc)){
				$name = $seg[0].'-'.$counter.'.'.$seg[1];
				break;
			}

			$counter++;
		}

		return $name;
	}
}

if ( ! function_exists('image_from_url'))
{
	function image_from_url ($url,$name='')
	{
		  if($name=='')
			$name = name_from_url($url);

		  $name = rename_if_exists($name,0);		

		  $ch 	= curl_init(); 
		  curl_setopt ($ch, CURLOPT_RETURNTRANSFER, 1);		  
		  curl_setopt($ch, CURLOPT_URL, $url);
		  curl_setopt($ch, CURLOPT_TIMEOUT, 0); 
		  curl_setopt ($ch, CURLOPT_USERAGENT, $_SERVER['HTTP_USER_AGENT']);
		  curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true); 
		  curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 0);
		  curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
		  curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
		  $response = curl_exec($ch); 
		  curl_close($ch); 

	   	  if(!empty($response))
		  {
		  	$date = date('dmY');
		  	$folderPath = 'uploads/images/'.$date.'/';
		  	if (!is_dir($folderPath)) {
				if (!mkdir($folderPath)) {
			        echo "Failed to create directory '$folderPath'.";die;
			    }
		  	}

		  	$fp = fopen($folderPath.$name, 'wb');
		  	fwrite($fp, $response);
		  	fclose($fp);
		  	return base_url($folderPath.$name);
		  }
		  else
			return false;
	}
}


if ( ! function_exists('listFilesRecursive'))
{
	function listFilesRecursive($dir) {
	    $files = [];

	    // List all files and directories in the current directory
	    $items = scandir($dir);

	    // Iterate over each item
	    foreach ($items as $item) {
	        // Ignore . and ..
	        if ($item === '.' || $item === '..') {
	            continue;
	        }

	        // Get the full path of the item
	        $path = $dir . DIRECTORY_SEPARATOR . $item;

	        // If it's a directory, recursively list its files
	        if (is_dir($path)) {
	            $files = array_merge($files, listFilesRecursive($path));
	        } else {
	            // If it's a file, add its filename and directory path to the list
	            $files[] = ['filename' => $item, 'path' => $dir];
	        }
	    }

	    return $files;
	}
}

if ( ! function_exists('gif2jpeg'))
{
	function gif2jpeg($p_fl, $p_new_fl='', $bgcolor=false)
	{
	  	list($wd, $ht, $tp, $at)=getimagesize($p_fl);
		$img_src=imagecreatefromgif($p_fl);
		$img_dst=imagecreatetruecolor($wd,$ht);
		$clr['red']=255;
		$clr['green']=255;
		$clr['blue']=255;
		
		if(is_array($bgcolor)) $clr=$bgcolor;
		$kek=imagecolorallocate($img_dst,
		$clr['red'],$clr['green'],$clr['blue']);
		imagefill($img_dst,0,0,$kek);
		imagecopyresampled($img_dst, $img_src, 0, 0, 0, 0, $wd, $ht, $wd, $ht);
	  	$draw=true;
		if(strlen($p_new_fl)>0)
		{
		    if($hnd=fopen($p_new_fl,'w'))
		    {
		    	$draw=false;
		    	fclose($hnd);
		    }
		}
		
		if(true==$draw)
		{
			header("Content-type: image/jpeg");
		    imagejpeg($img_dst);
		}
		else 
			imagejpeg($img_dst, $p_new_fl);
		  
		imagedestroy($img_dst);
		imagedestroy($img_src);
	}
}


if ( ! function_exists('resized_to_fixed_width'))
{

	function resized_to_fixed_width($img,$width=500)
	{
		$CI = get_instance();
		$config['image_library'] = 'gd2';
		$config['source_image'] = $img;
		$config['maintain_ratio'] = TRUE;
		$config['width'] = $width;

		$CI->load->library('image_lib', $config);

		$CI->image_lib->resize();
	}
}

if ( ! function_exists('create_rect_thumb'))
{

	function create_rect_thumb($img,$dest,$ratio=3)
	{

		$seg = explode('.',$img);	//explde the source to get the image extension
		$thumbType    = 'jpg';		//generated thumb will be of type jpg
		$thumbPath    = $dest;	//destination path of the thumb -- original image name will be appended
		$thumbQuality = 80;				//quality of the thumbnail (in percent)

		//chech the image type and create image accordingly
		if($seg[2]=='jpg' || $seg[2]=='JPG' || $seg[2]=='jpeg')
		{
			if (!$full = imagecreatefromjpeg($img)) {
			    return 'error';
			}
		}
		else if($seg[2]=='png')
		{
			if (!$full = imagecreatefrompng($img)) {
			    return 'error';
			}			
		}
		else if($seg[2]=='gif')
		{
			if (!$full = imagecreatefromgif($img)) {
			    return 'error';
			}			
		}

	    $width  = imagesx($full);
	    $height = imagesy($full);

	    /*wourk out the thumbnail size*/
	    $resizedHeight	= min($width*$ratio/8,$height);
	    $resizedWidth	= $width;
		 
	    /* work out starting point */
	    $thumbx = 0;	// x always starts at zero -- the thumbnail gets the same width as the source image
	    $extra_height = $height - $resizedHeight;
	    $thumby = floor(($extra_height) / 2);
		 
	    /* create the small smaller version, then crop it centrally to create the thumbnail */
	    $resized  = imagecreatetruecolor($resizedWidth, $resizedHeight);
	    imagecopy($resized, $full,0,0,$thumbx,$thumby,$resizedWidth,$resizedHeight);
		 
		$name = name_from_url($img);

	    imagejpeg($resized, $thumbPath.str_replace('_large.jpg', '_thumb.jpg', $name), $thumbQuality);
	}
}



if ( ! function_exists('put_watermark'))
{
	function put_watermark($src,$text='')
	{
		$CI = get_instance();
		$CI->load->library('image_lib');
		$config['source_image'] = $src;
		$config['wm_text'] = $text;
		$config['wm_type'] = 'text';
		$config['wm_font_path'] = './system/fonts/texb.ttf';
		$config['wm_font_size'] = '16';
		$config['wm_font_color'] = 'ffffff';
		$config['wm_vrt_alignment'] = 'bottom';
		$config['wm_hor_alignment'] = 'center';
		$config['wm_padding'] = '0';

		$CI->image_lib->initialize($config);

		$CI->image_lib->watermark();
	}
}

if ( ! function_exists('filePath'))
{
	function filePath($filePath)
	{
		$fileParts = pathinfo($filePath);

		if(!isset($fileParts['filename']))
		{
			$fileParts['filename'] = substr($fileParts['basename'], 0, strrpos($fileParts['basename'], '.'));
		}
	 
		return $fileParts;
	}
}


if ( ! function_exists('is_animated'))
{
	function is_animated($filename)
	{
        $filecontents=file_get_contents($filename);

        $str_loc=0;
        $count=0;
        while ($count < 2) # There is no point in continuing after we find a 2nd frame
        {
            $where1=strpos($filecontents,"\x00\x21\xF9\x04",$str_loc);
            if ($where1 === FALSE)
            {
                break;
            }
            else
            {
                $str_loc=$where1+1;
                $where2=strpos($filecontents,"\x00\x2C",$str_loc);
                if ($where2 === FALSE)
                {
                    break;
                }
                else
                {
                    if ($where1+8 == $where2)
                    {
                        $count++;
                    }
                                $str_loc=$where2+1;
                }
            }
        }

        if ($count > 1)
        {
            return TRUE;
        }
        else
        {
            return FALSE;
        }
	}
}

if ( ! function_exists('videoType'))
{
	function videoType($url) 
	{
	    if (strpos($url, 'youtube') > 0) 
	    {
	        return 'youtube';
	    } 
	    elseif (strpos($url, 'vimeo') > 0) 
	    {
	        return 'vimeo';
	    }
	    else 
	    {
	        return 'unknown';
	    }
	}
}

if ( ! function_exists('load_view'))
{
	function load_view($view='',$data=array(),$buffer=FALSE,$theme='')
	{
		$CI 	= get_instance();
		if($theme=='')
		$theme 	= get_active_theme();
		if($buffer==FALSE)
		{
			if(@file_exists(APPPATH."modules/themes/views/".$theme."/".$view.".php"))
			$CI->load->view('themes/'.$theme.'/'.$view,$data);
			else
			$CI->load->view('themes/default/'.$view,$data);	
		}
		else
		{
			if(@file_exists(APPPATH."modules/themes/views/".$theme."/".$view.".php"))
			$view_data = $CI->load->view('themes/'.$theme.'/'.$view,$data,TRUE);
			else
			$view_data = $CI->load->view('themes/default/'.$view,$data,TRUE);	
			return $view_data;
		}
	}
}

if ( ! function_exists('load_template'))
{
	function load_template($data=array(),$theme='',$tmpl='template_view')
	{
		$row 	= get_option('site_settings');
		if(is_array($row) && isset($row['error']))
		{
			echo 'Site settings not found.error on : epbase_helper';
			die();
		}
		else
		{
			$values 		= json_decode($row->values);
			$data['title'] 	= $values->site_title;
		}

		load_view($tmpl,$data);
	}
}

if ( ! function_exists('get_active_theme'))
{
	function get_active_theme()
	{
		$row = get_option('active_theme');
		if(is_array($row) && isset($row['error']))
		{
			return 'default';
		}
		else
			return $row->values;
	}
}

if ( ! function_exists('get_option'))
{
	function get_option($key='')
	{
		$CI = get_instance();
		$query = $CI->db->get_where('options',array('key'=>$key,'status'=>1));		
		if($query->num_rows()>0)
			return $query->row();
		else
			return array('error'=>'Key not found');
	}
}

if ( ! function_exists('update_option'))
{
	function update_option($key='',$values=array())
	{
		$CI = get_instance();
		$data['values'] = json_encode($values);
		echo $key;
		print_r($data);
		$query = $CI->db->update('options',$data,array('key'=>$key));		
	}
}


if ( ! function_exists('get_plugins'))
{
	function get_plugins()
	{
		$CI = get_instance();
		$query = $CI->db->get_where('plugins',array('status'=>1));		
		return $query;
	}
}

if ( ! function_exists('get_widgets_by_position'))
{
	function get_widgets_by_position($pos='')
	{
		$CI = get_instance();
		$positions = get_option('positions');
		$positions = json_decode($positions->values);
		$widgets = array();
		foreach($positions as $position)
		{
			if($position->name==$pos)
			{
				if(isset($position->widgets))
				$widgets = $position->widgets;
			}
		}
		return $widgets;
	}
}

if ( ! function_exists('configPagination'))
{
	function configPagination($url,$total_rows,$segment,$per_page=10)
	{
		$CI = get_instance();
		$CI->load->library('pagination');
		$config['base_url'] 		= site_url($url);
		$config['total_rows'] 		= $total_rows;
		$config['per_page'] 		= $per_page;
		$config['uri_segment'] 		= $segment;
		$config['full_tag_open'] 	= '<div class="pagination"><ul>';
		$config['full_tag_close'] 	= '</ul></div>';
		$config['num_tag_open'] 	= '<li>';
		$config['num_tag_close'] 	= '</li>';
		$config['cur_tag_open'] 	= '<li class="active"><a href="#">';
		$config['cur_tag_close']	= '</a></li>';
		$config['num_links'] 		= 5;
		$config['next_tag_open'] 	= "<li>";
		$config['next_tag_close'] 	= "</li>";
		$config['prev_tag_open'] 	= "<li>";
		$config['prev_tag_close'] 	= "</li>";
		
		$config['first_link'] 	= FALSE;
		$config['last_link'] 	= FALSE;
		$CI->pagination->initialize($config);
		
		return $CI->pagination->create_links();
	}
}

if ( ! function_exists('cache_category_counts'))
{
	function cache_category_counts()
	{
		$CI = get_instance();
		$CI->load->config('webhelios');
		if($CI->config->item('cache_category_counts')=='Y')
		{
			$CI->load->database();
			$sql = "select count(id) as TOTAL,category from ".$CI->db->dbprefix('news')." where status=1 group by category";
			$query = $CI->db->query($sql);
			foreach ($query->result() as $row) 
			{
				$CI->session->set_userdata('cat'.$row->category,$row->TOTAL);
			}

			$sql = "select count(id) as TOTAL,sub_category from ".$CI->db->dbprefix('news')." where status=1 group by sub_category";
			$query = $CI->db->query($sql);
			foreach ($query->result() as $row) 
			{
				$CI->session->set_userdata('cat'.$row->sub_category,$row->TOTAL);
			}			
		}
	}
}

if ( ! function_exists('count_news_by_category'))
{
	function count_news_by_category($id='')
	{
		$CI = get_instance();

		if($id==0)
			return '0';

		$CI->load->config('webhelios');
		if($CI->config->item('cache_category_counts')=='Y')
		{
			if($CI->session->userdata('cat'.$id)!='')
			{
				return $CI->session->userdata('cat'.$id);
			}
			else
			{
				$CI->load->database();
				$sql = "select count(id) as TOTAL from ".$CI->db->dbprefix('news')." where category=".$id;
				$query = $CI->db->query($sql);
				$total = $query->row()->TOTAL;
				$CI->session->set_userdata('cat'.$id,$total);
				return $total;			
			}
		}
		else
		{
			$CI->load->database();
			$sql = "select count(id) as TOTAL from ".$CI->db->dbprefix('news')." where category=".$id;
			$query = $CI->db->query($sql);
			$total = $query->row()->TOTAL;
			return $total;			
		}
	}
}


if ( ! function_exists('count_news_by_subcategory'))
{
	function count_news_by_subcategory($id='')
	{
		$CI = get_instance();
		
		if($id==0)
			return '0';

		$CI->load->config('webhelios');
		if($CI->config->item('cache_category_counts')=='Y')
		{

			if($CI->session->userdata('cat'.$id)!='')
			{
				return $CI->session->userdata('cat'.$id);
			}
			else
			{
				$CI->load->database();
				$sql = "select count(id) as TOTAL from ".$CI->db->dbprefix('news')." where sub_category=".$id;
				$query = $CI->db->query($sql);
				$total = $query->row()->TOTAL;
				$CI->session->set_userdata('cat'.$id,$total);
				return $total;			
			}
		}
		else
		{
			$CI->load->database();
			$sql = "select count(id) as TOTAL from ".$CI->db->dbprefix('news')." where sub_category=".$id;
			$query = $CI->db->query($sql);
			$total = $query->row()->TOTAL;
			return $total;			
		}

	}
}


if ( ! function_exists('get_category_title_by_id'))
{
	function get_category_title_by_id($id='')
	{
		if($id==0)
			return 'No parent';
		$CI = get_instance();
		$CI->load->database();
		$query = $CI->db->get_where('categories',array('id'=>$id));
		if($query->num_rows()>0)
		{
			$row = $query->row();
			return lang_key($row->title);
		}
		else
			return '';
	}
}

if ( ! function_exists('get_source_title_by_id'))
{
    function get_source_title_by_id($id='')
    {
        if($id==0)
            return 'No Source';
        $CI = get_instance();
        $CI->load->database();
        $query = $CI->db->get_where('sources',array('id'=>$id));
        if($query->num_rows()>0)
        {
            $row = $query->row();
            return lang_key($row->source_name);
        }
        else
            return '';
    }
}



if ( ! function_exists('get_profile_photo_by_id'))
{
	function get_profile_photo_by_id($id='',$type='')
	{
		if($id==0)
			return 'No found';

		$CI = get_instance();
		$CI->load->database();
		$query = $CI->db->get_where('users',array('id'=>$id));
		if($query->num_rows()>0)
		{
			$row = $query->row();
			if($row->profile_photo=='')
				return base_url().'assets/images/nophoto.jpg';
			
			if($type=='thumb')
			return base_url().'uploads/profile_photos/thumb/'.$row->profile_photo;
			else
			return base_url().'uploads/profile_photos/'.$row->profile_photo;
		}
		else
		{

			return base_url().'assets/images/nophoto.jpg';
		}
	}
}

if ( ! function_exists('get_profile_photo_name_by_username'))
{
	function get_profile_photo_name_by_username($username='',$type='thumb')
	{
		if($username=='')
			return 'Not found';

		$CI = get_instance();
		$CI->load->database();
		$query = $CI->db->get_where('users',array('user_name'=>$username));
		if($query->num_rows()>0)
		{
			$row = $query->row();
			if($row->profile_photo!='')
			return $row->profile_photo;
			else
			return 'nophoto-'.strtolower($row->gender).'.jpg';
		}
		else
			return 'nophoto-.jpg';
	}
}

if ( ! function_exists('get_profile_photo_by_username'))
{
	function get_profile_photo_by_username($username='',$type='thumb')
	{
		if($username=='')
			return 'Not found';

		$CI = get_instance();
		$CI->load->database();
		$query = $CI->db->get_where('users',array('user_name'=>$username));
		if($query->num_rows()>0)
		{
			$row = $query->row();
			if($row->profile_photo!='')
			return base_url().'uploads/profile_photos/'.$type.'/'.$row->profile_photo;
			else
			return base_url().'assets/images/nophoto.jpg';
		}
		else
			return base_url().'assets/images/nophoto.jpg';
	}
}




if ( ! function_exists('get_view_count'))
{
	function get_view_count($post_id,$from='all')
	{
		if (isset($_COOKIE['viewcookie'.$post_id])==FALSE && $from=='detail')
		{
			$CI = get_instance();
			$CI->load->database();

			$query = $CI->db->get_where('posts',array('id'=>$post_id));
			if($query->num_rows()>0)
			{
				$row = $query->row();
				$total_view = $row->total_view;
				$total_view++;
			}		
			else
				$total_view = 0;	
			$CI->db->update('posts',array('total_view'=>$total_view),array('id'=>$post_id));
			setcookie("viewcookie".$post_id, 1, time()+1800);
			return $total_view;
		}
		else
		{
			$CI = get_instance();
			$CI->load->database();

			$query = $CI->db->get_where('posts',array('id'=>$post_id));
			if($query->num_rows()>0)
			{
				$row = $query->row();
				return $row->total_view;
			}		
			else
				$total_view = 0;				
		}
	}
}

/*
if ( ! function_exists('get_all_classifieds_map_data'))
{
    function get_all_classifieds_map_data()
    {    	
        $CI = get_instance();
        $limit = $CI->config->item('banner_map_post_limit');
        if(empty($limit))
        	$limit = 200;
        
        $CI->load->database();
        $query 	= $CI->db->get_where('posts',array('status'=> 1),$limit,0);
        $data 	= array();
        $posts 	= array();

		$i=0;
        foreach ($query->result() as $row)
        {
			$i++;
            $post = array();
			$post['post_id'] 			= $row->id;
			$post['post_title'] 		= get_post_data_by_lang($row,'title');
			$post['post_purpose'] 		= $row->purpose;
			$post['featured_image_url'] = get_featured_photo_by_id($row->featured_img);
			$post['latitude'] 			= $row->latitude;
			$post['longitude'] 			= $row->longitude;
			$post['price'] 				= show_price($row->price);
			$post['post_short_address'] = get_location_name_by_id($row->city);
			$post['detail_link'] 		= post_detail_url($row);
			$post['parent_category'] 	= get_category_title_by_id($row->parent_category);
			$post['fa_icon'] 			= get_category_fa_icon($row->parent_category);

			if($i%3 == 1)
				$color = "#ed5441";
			else if($i%3 == 2)
				$color = "#51d466";
			else
				$color = "#609cec";
			$post['fa_color'] = $color;
            array_push($posts,$post);
        }

        $data['posts'] = $posts;
        return $data;
    }
}

if ( ! function_exists('get_classifieds_map_data_single'))
{
	function get_classifieds_map_data_single($row)
	{
		$data 	= array();
		$posts 	= array();

			$post = array();
			$post['post_id'] 			= $row->id;
			$post['post_title'] 		= get_post_data_by_lang($row,'title');;
			$post['post_purpose'] 		= $row->purpose;
			$post['featured_image_url'] = get_featured_photo_by_id($row->featured_img);
			$post['latitude'] 			= $row->latitude;
			$post['longitude'] 			= $row->longitude;
			$post['price'] 				= show_price($row->price);
			$post['post_short_address'] = get_location_name_by_id($row->city);
			$post['detail_link'] 		= post_detail_url($row);
			$post['parent_category'] 	= get_category_title_by_id($row->parent_category);
			array_push($posts,$post);

		$data['posts'] = $posts;
		return json_encode($data);
	}
}

if ( ! function_exists('get_formatted_address'))
{
	function get_formatted_address($address, $city, $state, $country, $zip_code,$hide_address='')
	{
		if($hide_address==1)
		return get_location_name_by_id($city).', '.get_location_name_by_id($state).' '.$zip_code.', '.get_location_name_by_id($country);
		else
		return $address.', '.get_location_name_by_id($city).', '.get_location_name_by_id($state).' '.$zip_code.', '.get_location_name_by_id($country);
	}
}

if ( ! function_exists('prepare_map_json_from_query'))
{
    function prepare_map_json_from_query($query)
    {
        $CI 	= get_instance();
        $data 	= array();
        $posts 	= array();

		$i = 0;
        foreach ($query->result() as $row)
        {
			$i++;
            $post = array();
            $post['post_id'] 			= $row->id;
			$post['post_title'] 		= get_post_data_by_lang($row,'title');
			$post['post_purpose'] 		= $row->purpose;
			$post['featured_image_url'] = get_featured_photo_by_id($row->featured_img);
			$post['latitude'] 			= $row->latitude;
			$post['longitude'] 			= $row->longitude;
			$post['price'] 				= show_price($row->price);
			$post['post_short_address'] = get_location_name_by_id($row->city);
			$post['detail_link'] 		= post_detail_url($row);
			$post['parent_category'] 	= get_category_title_by_id($row->parent_category);
			$post['fa_icon'] 			= get_category_fa_icon($row->parent_category);
			if($i%3 == 1)
				$color = "#ed5441";
			else if($i%3 == 2)
				$color = "#51d466";
			else
				$color = "#609cec";
			$post['fa_color'] = $color;
			array_push($posts,$post);
        }

        $data['posts'] = $posts;
        return $data;
    }
}
*/
if ( ! function_exists('create_rectangle_thumb'))
{
    function create_rectangle_thumb($img,$dest)
    {
        $seg = explode('.',$img);
        $thumbType    	= 'jpg';
        $thumbSize    	= 300;
        $thumbWidth 	= 300;
        $thumbHeight 	= 226;
        $thumbPath    	= $dest;
        $thumbQuality 	= 100;

        $last_index = count($seg);
        $last_index--;

        if(strcasecmp($seg[$last_index], 'jpg') == 0 || strcasecmp($seg[$last_index], 'jpeg') == 0)
        {
            if (!$full = imagecreatefromjpeg($img)) {
                return 'error';
            }
        }
        else if(strcasecmp($seg[$last_index], 'png') == 0)
        {
            if (!$full = imagecreatefrompng($img)) {
                return 'error';
            }
        }
        else if(strcasecmp($seg[$last_index], 'gif') == 0)
        {
            if (!$full = imagecreatefromgif($img)) {
                return 'error';
            }
        }

        $width  = imagesx($full);
        $height = imagesy($full);

        /* work out the smaller version, setting the shortest side to the size of the thumb, constraining height/wight */
        if ($height > $width) {
            $divisor = $width / $thumbHeight;
        } else {
            $divisor = $height / $thumbWidth;
        }

        $resizedWidth   = ceil($width / $divisor);
        $resizedHeight  = ceil($height / $divisor);

        /* work out center point */
        $thumbx = floor(($resizedWidth  - $thumbWidth) / 2);
        $thumby = floor(($resizedHeight - $thumbHeight) / 2);

        /* create the small smaller version, then crop it centrally to create the thumbnail */
        $resized  = imagecreatetruecolor($resizedWidth, $resizedHeight);
        $thumb    = imagecreatetruecolor($thumbWidth, $thumbHeight);
        imagecopyresized($resized, $full, 0, 0, 0, 0, $resizedWidth, $resizedHeight, $width, $height);
        imagecopyresized($thumb, $resized, 0, 0, $thumbx, $thumby, $thumbWidth, $thumbHeight, $thumbWidth, $thumbHeight);

        $name = name_from_url($img);

        imagejpeg($thumb, $thumbPath.str_replace('_large.jpg', '_thumb.jpg', $name), $thumbQuality);
    }

}

if ( ! function_exists('get_category_parent_by_id'))
{
    function get_category_parent_by_id($id)
    {

    	$CI = get_instance();
    	$CI->load->database();
    	$query = $CI->db->get_where('categories',array('id'=>$id,'status'=>1));
        if($query->num_rows()>0)
        {
        	$row = $query->row();
        	if($row->parent==0)
        		return $id;
        	else
        		return $row->parent;
        }
        else
        {
        	return $id;
        }
    }
}

if ( ! function_exists('get_category_image'))
{
	function get_category_image($id)
	{

		$CI = get_instance();
		$CI->load->database();
		$query = $CI->db->get_where('categories',array('id'=>$id,'status'=>1));
		if($query->num_rows()>0)
		{
			$row = $query->row();

			if($row->featured_img != '')
				return base_url('uploads/thumbs/'.$row->featured_img);
			else
				return base_url('assets/images/no-image.jpeg');
		}
		else
		{
			return base_url('assets/images/no-image.jpeg');
		}
	}
}

if ( ! function_exists('get_category_fa_icon'))
{
	function get_category_fa_icon($id)
	{

		$CI = get_instance();
		$CI->load->database();
		$query = $CI->db->get_where('categories',array('id'=>$id,'status'=>1));
		if($query->num_rows()>0)
		{
			$row = $query->row();

			if($row->fa_icon != '')
				return $row->fa_icon;
			else
				return 'fa-picture-o';
		}
		else
		{
			return 'fa-picture-o';
		}
	}
}
/*
if ( ! function_exists('remove_feature_expiration'))
{
	function remove_feature_expiration ($today)
	{
		$CI = get_instance();
		$CI->load->database();
		
		$CI->db->where('featured',1);
		$CI->db->where('status',1);
		$CI->db->where('featured_expiration_date <',$today);
		$CI->db->update('posts',array('featured'=>0));
	}
}

if ( ! function_exists('remove_post_expiration'))
{
	function remove_post_expiration ($today)
	{
		$CI = get_instance();
		$CI->load->database();

		$CI->db->where('status',1);
		$CI->db->where('expirtion_date <',$today);
		$CI->db->update('posts',array('status'=>4));
	}
}

if ( ! function_exists('expiration_cron'))
{
	function expiration_cron ()
	{
		$CI = get_instance();

		$CI->load->helper('date');
		$datestring = "%Y-%m-%d";
		$time  = time();
		$today = mdate($datestring, $time);

		$option = get_option('last_expiration_cron_date');
		
		if((is_array($option) && isset($option['error'])) || strtotime($option->values)<strtotime($today))
		{
			ini_set('max_execution_time', 3600);
			if(get_settings('global_settings','hide_posts_if_expired','Yes')=='Yes')
			remove_post_expiration($today);
		
			remove_feature_expiration($today);
			
			add_option('last_expiration_cron_date',$today);
		}

	}
}

if ( ! function_exists('get_post_sell_count'))
{
	function get_post_sell_count()
	{

		$CI = get_instance();
		$CI->load->database();

		$CI->db->where('status',1);
		$query = $CI->db->get_where('posts',array('purpose'=>'sell'));
		return $query->num_rows();

	}
}

if ( ! function_exists('get_post_buy_count'))
{
	function get_post_buy_count()
	{

		$CI = get_instance();
		$CI->load->database();

		$CI->db->where('status',1);
		$query = $CI->db->get_where('posts',array('purpose'=>'buy'));
		return $query->num_rows();

	}
}
*/
if ( ! function_exists('translateable_date'))
{
	function translateable_date($time)
	{

		$mon  = date('F', $time);
		$day  = date('d', $time);
		$year = date('Y', $time);

		return lang_key(strtolower($mon)).' '.$day.', '.$year;
	}
}

if ( ! function_exists('grab_duration_options'))
{
	function grab_duration_options()
	{
		$diff = 1; // change this value on version 1.3
		$options = array();
		for($i=$diff;$i<=24;$i=$i+$diff)
		{
			$options[$i] = $i.' '.lang_key('hours');
		}

		return $options;
	}
}

if ( ! function_exists('start_time_options'))
{
	function start_time_options()
	{
		$diff = 6;
		$options = array();
		
		$start = "0:00";
		$end = "23:00";

		$tStart = strtotime($start);
		$tEnd = strtotime($end);
		$tNow = $tStart;

		$i = 0;
		while($tNow <= $tEnd){
		  #echo date("h:i a",$tNow)."\n";
		  $options[$i] = date("h:i a",$tNow);
		  $tNow = strtotime('+60 minutes',$tNow);
		  $i++;
		}
		return $options;
	}
}

if ( ! function_exists('item_per_grab_options'))
{
	function item_per_grab_options()
	{
		$diff = 5;
		$options[3] = 3;
		for($i=$diff;$i<=50;$i=$i+$diff)
		{
			$options[$i] = $i;
		}

		return $options;
	}
}

if ( ! function_exists('get_category_id_by_key'))
{
    function get_category_id_by_key($key)
    {
        $CI = get_instance();
        $CI->load->database();
        $CI->db->where('title',$key);
        $query= $CI->db->get('categories');
        if($query->num_rows()>0)
        {
            $row = $query->row();
            return $row->id;
        }
        else
            return -1;
    }
}

if ( ! function_exists('get_source_id_by_key'))
{
    function get_source_id_by_key($key)
    {
        $CI = get_instance();
        $CI->load->database();
        $CI->db->where('source_name',$key);
        $query= $CI->db->get('sources');
        if($query->num_rows()>0)
        {
            $row = $query->row();
            return $row->id;
        }
        else
            return -1;

    }
}

if ( ! function_exists('get_excerpt'))
{
    function get_excerpt($description='')
    {
        $description = preg_replace("/<img[^>]+\>/i", "", $description); 
        $description = strip_tags($description); 
        return $description;
    }
}
// added on version 1.4
if ( ! function_exists('check_news_edit_permission'))
{
    function check_news_edit_permission($id='')
    {
    	$CI = get_instance();
    	if($id=='')
    	{
			if(is_admin())
	    		return TRUE;
	    	else if(is_moderator() && get_settings('global_settings','moderator_can_create_post','No')=='Yes')
	    		return TRUE;
	    	else if(is_generaluser() && get_settings('global_settings','generaluser_can_create_post','No')=='Yes')
	    	{
	    		return TRUE;
	    	}
	    	else
	    		return FALSE; 
    	}
    	else
    	{
	    	$CI->load->model('admin/content_model');
	    	$news = $CI->content_model->get_news_data_by_id($id);
	    	if(is_admin())
	    		return TRUE;
	    	else if(is_moderator() && get_settings('global_settings','moderator_can_create_post','No')=='Yes')
	    		return TRUE;
	    	else if(is_generaluser() && get_settings('global_settings','generaluser_can_create_post','No')=='Yes' && $news->author==$CI->session->userdata('user_id'))
	    	{
	    		return TRUE;
	    	}
	    	else
	    		return FALSE;    		
    	}
    }
}

if ( ! function_exists('post_short_url'))
{
	function post_short_url($news='')
	{
	  $short_url = get_short_url($news['id'],'0');
	  if($short_url==0)
	  {
	  	  $url = post_detail_url($news);
		  $url 	= 'https://is.gd/create.php?format=simple&url='.urlencode($url);
		  $ch 	= curl_init(); 
		  curl_setopt($ch, CURLOPT_URL, $url); 
		  curl_setopt($ch, CURLOPT_USERAGENT, "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/47.0.2526.73 Safari/537.36"); 
		  curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1); 
		  curl_setopt($ch, CURLOPT_TIMEOUT, 0); 
		  curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 0);
		  curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
		  $response = curl_exec($ch); 
		  //$errmsg = curl_error($ch);  
		  curl_close($ch); 
		  if(!empty($response))
		  {
		  	add_short_url($news['id'],$response);
		  	return $response;
		  }
		  else
		  	return '';
	  	
	  }
	  else
	  	return $short_url;

	}
}

if ( ! function_exists('get_url_content'))
{
	function get_url_content($url='')
	{


		  $ch 	= curl_init(); 
		  curl_setopt ($ch, CURLOPT_RETURNTRANSFER, 1);		  
		  curl_setopt($ch, CURLOPT_URL, $url);
		  curl_setopt($ch, CURLOPT_TIMEOUT, 0); 
		  curl_setopt ($ch, CURLOPT_USERAGENT, $_SERVER['HTTP_USER_AGENT']);
		  curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true); 
		  curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 0);
		  curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
		  curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
		  $response = curl_exec($ch);
		  
		  $error = '';

		  if (!curl_errno($ch)) {
			  switch ($http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE)) {
			    case 200:  # OK
			      break;
			    default:
			      $error = 'Unexpected HTTP code: '. $http_code. "\n";
			  }
			}
		  
		  curl_close($ch);

		  if(!empty($response))
		  {
		  	return array('response'=>$response,'error'=>0);
		  }
		  else
		  {		  	
		  	return array('response'=>'','error'=>$error);	  	
		  }
	}
}

if ( ! function_exists('format_long_text'))
{
	function format_long_text($string,$length=20)
	{
		$string = html_entity_decode($string);
		$string = strip_tags($string);

		if (strlen($string) > $length) {

		    $string = mb_substr($string, 0, $length).'...';
		}

		return $string;	
	}
}


if ( ! function_exists('get_all_post_count'))
{
	function get_all_post_count($user_id='')
	{

		$CI = get_instance();
		$CI->load->database();
		$CI->db->where('status',1);
		if(!empty($user_id))
			$CI->db->where('created_by',$user_id);
        $CI->db->select('count(*) as TOTAL');
        $query = $CI->db->get('news');
        return $query->row()->TOTAL;

	}
}

if ( ! function_exists('resolve_mixed_url'))
{
	function resolve_mixed_url($media='')
	{
		$media = '#'.$media;
		$media = str_replace("#https://", "//", $media);
		$media = str_replace("#http://", "//", $media);
		return $media;
	}
}

if ( ! function_exists('resolve_matching_img'))
{
	function resolve_matching_img($html='',$srcToRemove='')
	{
		// Regular expression pattern to match <img> tags with the specified src attribute
		$pattern = '/<img[^>]*src="' . preg_quote($srcToRemove, '/') . '"[^>]*>/i';

		// Remove matching <img> tags from the HTML
		$modifiedHtml = preg_replace($pattern, '', $html);

		// Output the modified HTML
		return $modifiedHtml;
	}
}

if ( ! function_exists('remove_first_img'))
{
	function remove_first_img($html='',$srcToRemove='')
	{
		$pattern = '/<img[^>]*>/i';

		// Find the first <img> tag
		if (preg_match($pattern, $html, $matches)) {
		    $firstImageTag = $matches[0];

		    // Remove the first <img> tag from the HTML
		    $modifiedHtml = preg_replace($pattern, '', $html, 1);

		    // Output the modified HTML
		    return $modifiedHtml;
		} else {
		    return $html;
		}
	}
}


if ( ! function_exists('remove_unwanted_text'))
{
	function remove_unwanted_text($html='')
	{
		$html = str_replace('<a href="https://blockads.fivefilters.org/acceptable.html">(Why?)</a>', "", $html);
		$html = str_replace('<a href="https://blockads.fivefilters.org">Adblock test</a>', "", $html);
		return $html;
	}
}


//end

/* End of file array_helper.php */
/* Location: ./system/helpers/array_helper.php */