<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
/**
 * BusinessDirectory category_model_core model
 *
 * This class handles category_model_core management related functionality
 *
 * @package		Admin
 * @subpackage	category_model_core
 * @author		webhelios
 * @link		http://webhelios.com
 */
class Category_model_core extends CI_Model 
{
	var $category,$menu;

	function __construct()
	{
		parent::__construct();
		$this->load->database();

		$fields = $this->db->list_fields('categories');	

		if (!in_array('featured_img', $fields)) {
			$sql = "ALTER TABLE `".$this->db->dbprefix('categories')."` ADD `featured_img` CHAR(200) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL AFTER `status`;";
			$this->db->query($sql);
		}	

		if (!in_array('show_menu', $fields)) {
			$sql = "ALTER TABLE `".$this->db->dbprefix('categories')."` ADD `show_menu`  int(11) NOT NULL DEFAULT 0 AFTER `status`;";
			$this->db->query($sql);
		}		

		$this->category = array();
	}

	function get_all_parent_categories_by_range()
	{
		$this->db->order_by('show_menu', "asc");
		$this->db->where('parent',0); 
		$this->db->where('status',1); 
		$query = $this->db->get('categories');
		return $query;
	}


	function get_all_categories_by_range($start,$sort_by='')
	{
		$this->db->order_by($sort_by, "asc");
		$this->db->where('status',1); 
		$query = $this->db->get('categories');
		return $query;
	}

	function delete_category_by_id($id)
	{
		$data['status'] = 0;
		$this->db->update('categories',$data,array('id'=>$id));
	}

	function insert_category($data)
	{
		$this->db->insert('categories',$data);
		return $this->db->insert_id();
	}

	function update_category($data,$id)
	{
		$this->db->update('categories',$data,array('id'=>$id));
	}

	function get_category_by_id($id)
	{
		$query = $this->db->get_where('categories',array('id'=>$id));
		if($query->num_rows()<=0)
		{
			echo 'Invalid category id';die;
		}
		else
		{
			return $query->row();
		}
	}

	function get_all_subcategories_by_parent($parent)
	{
		$this->db->order_by('title', "asc");
		$this->db->where('parent',$parent); 
		$this->db->where('status',1); 
		$query = $this->db->get('categories');
		return $query;
	}

}

/* End of file category_model_core.php */
/* Location: ./system/application/models/category_model_core.php */