<div class="row">

    <div class="col-md-12">

        <?php echo ($this->session->flashdata('msg')); ?>

        <a href="<?php echo site_url('admin/users/create');?>" class="btn btn-sm btn-success"><?php echo lang_key('create_user'); ?></a>
        <a href="<?php echo site_url('admin/users/exportemails');?>" class="btn btn-sm btn-info"><?php echo lang_key('export_user_email'); ?></a>
        <a href="<?php echo site_url('admin/users/exportphones');?>" class="btn btn-sm btn-primary"><?php echo lang_key('export_user_phone'); ?></a>
        <a href="<?php echo site_url('admin/users/sendemail'); ?>" class="btn btn-sm btn-warning"><?php echo lang_key('send_email_to_users');?></a>
        <div inline-class="admin_inline_239"></div>

        <div class="box">

            <div class="box-title">

                <h3><i class="fa fa-bars"></i> <?php echo lang_key('all_users'); ?></h3>

                <?php $page = ($this->uri->segment(5)!='')?$this->uri->segment(5):0;?>

                <div class="box-tool">

                    <a href="javascript:void(0);" data-action="collapse"><i class="fa fa-chevron-up"></i></a>

                </div>

            </div>
            <div class="box-content">
                <?php $this->load->helper('text'); ?>
                <?php if ($posts->num_rows() <= 0) { ?>
                    <div class="alert alert-info"><?php echo lang_key('no_pages'); ?></div>
                <?php } else { ?>
                    <div id="no-more-tables">
                        <table id="all-posts" class="table table-hover">
                            <thead>
                            <tr>
                                <th class="numeric">#</th>
                                <th class="numeric"><?php echo lang_key('image'); ?></th>
                                <th class="numeric"><?php echo lang_key('name'); ?></th>
                                <th class="numeric"><?php echo lang_key('type');?></th>
                                <th class="numeric"><?php echo lang_key('email'); ?></th>
                                <th class="numeric"><?php echo lang_key('gender'); ?></th>
                                <th class="numeric"><?php echo lang_key('status');?></th>
                                <th class="numeric"><?php echo lang_key('options');?></th>
                            </tr>
                            </thead>
                            <tbody>
                            <?php $i = 1;

                            foreach ($posts->result() as $row): ?>

                                <tr>
                                    <td data-title="#" class="numeric"><?php echo html_escape($i); ?></td>
                                    <td data-title="<?php echo lang_key('image'); ?>" class="numeric">

                                        <img src="<?php echo get_profile_photo_by_id($row->id,'thumb'); ?>" class="thumbnail" inline-class="admin_inline_240">

                                    </td>
                                    <td data-title="<?php echo lang_key('name'); ?>" class="numeric"><a

                                            href="<?php echo site_url('admin/users/detail/' . $row->id); ?>"><?php echo html_escape($row->user_name); ?></a>

                                    </td>
                                    <td data-title="<?php echo lang_key('type');?>"  class="numeric">
                                    <?php 
                                        echo get_user_type_by_id($row->user_type);
                                    ?>
                                    </td>
                                    <td data-title="<?php echo lang_key('email'); ?>" class="numeric"><?php echo html_escape($row->user_email);; ?></td>
                                    <td data-title="<?php echo lang_key('gender'); ?>"

                                        class="numeric"><?php echo ($row->gender == '') ? 'N/A' : lang_key($row->gender); ?></td>
                                    <td data-title="<?php echo lang_key('status');?>" class="numeric">

                                        <?php

                                        if ($row->confirmed != 1)

                                             echo '<div class="badge badge-info">'.lang_key('PENDING').'</div>';

                                        else if ($row->banned == 1)

                                            echo '<div class="badge badge-danger">'.lang_key('BANNED').'</div>';

                                        else {

                                            echo '<div class="badge badge-success">'.lang_key('ACTIVE').'</div>';

                                        }

                                        ?>

                                    </td>

                                    <td data-title="<?php echo lang_key('options');?>" class="numeric">



                                        <div class="dropdown">



                                            <a class="btn btn-sm btn-info dropdown-toggle" data-toggle="dropdown"

                                               href=""><i class="fa fa-cog"></i> <?php echo lang_key('action');?> <span

                                                    class="caret"></span></a>



                                            <div class="dropdown-menu" aria-labelledby="dropdownMenuButton">

                                                <!--li><a href="<?php echo site_url('admin/userdetail/' . $row->user_name) ?>"

                                                       target="_blank">Profile</a></li-->
                                                <a class="dropdown-item" href="<?php echo site_url('admin/edituser/' . $row->id); ?>"><?php echo lang_key('edit');?></a>

                                                

                                                <a class="dropdown-item" href="<?php echo site_url('admin/userdetail/' . $row->id); ?>">Detail</a>

                                                

                                                <?php if($row->confirmation_key!=''){?>

                                                <a class="dropdown-item" href="<?php echo site_url('admin/confirmuser/'.$page.'/'. $row->id); ?>">Confirm</a>

                                                

                                                <?php }?>                                        


                                                <?php if($row->user_type!=1){?>

                                                    <a class="dropdown-item" href="<?php echo site_url('admin/deleteuser/'.$page.'/'. $row->id); ?>"><?php echo lang_key('delete');?></a>

                                                    

                                                    <?php

                                                    if ($row->banned == 1) {

                                                        ?>

                                                            <a  class="dropdown-item" href="<?php echo site_url('admin/users/unban_user/' . $row->id . '/' . $this->uri->segment(5)); ?>">Un-Ban</a>


                                                    <?php

                                                    } else {

                                                        ?>


                                                            <a class="dropdown-item" href="<?php echo site_url('admin/users/ban_user/' . $row->id . '/' . $this->uri->segment(5)); ?>">Ban</a>

                                                    <?php

                                                    }

                                                }

                                                ?>

                                            </div>



                                        </div>



                                    </td>



                                </tr>

                                <?php $i++;endforeach; ?>

                            </tbody>

                        </table>

                    </div>
                <?php } ?>

            </div>

        </div>

    </div>

</div>