<div class="row">
    <div class="col-md-12">
        <?php echo $this->session->flashdata('msg');?>
        <div class="box">
            <div class="box-title">
                <h3><i class="fa fa-bars"></i><?php echo lang_key_admin('create_widget');?></h3>
                <div class="box-tool">
                    <a href="#" data-action="collapse"><i class="fa fa-chevron-up"></i></a>

                </div>
            </div>
            <div class="box-content">
                <form action="<?php echo site_url('admin/widgets/create');?>" method="post">
                    <div class="form-group">
                        <label class="col-sm-4 col-lg-2 control-label"><?php echo lang_key_admin('name');?>:</label>
                        <div class="col-sm-4 col-lg-5 controls">
                            <input type="text" name="name" value="" placeholder="<?php echo lang_key_admin('type_something');?>" class="form-control input-sm" >
                            <?php echo form_error("name");?>
                        </div>
                    </div>
                    <div class="clearfix"></div>
                    <div class="form-group">
                        <label class="col-sm-4 col-lg-2 control-label">&nbsp;</label>
                        <div class="col-sm-4 col-lg-5 controls">
                            <button class="btn btn-primary" type="submit"><i class="fa fa-check"></i> <?php echo lang_key_admin('create');?></button>
                        </div>
                    </div>
                    <div class="clearfix"></div>
                </form>
            </div>
        </div>
    </div>
</div>

<div class="row">
    <div class="col-md-12">
        <div class="box">
            <div class="box-title">
                <h3><i class="fa fa-bars"></i><?php echo lang_key_admin('generate_widgets');?></h3>
                <div class="box-tool">
                    <a href="#" data-action="collapse"><i class="fa fa-chevron-up"></i></a>

                </div>
            </div>
            <div class="box-content">
                <form action="<?php echo site_url('admin/widgets/generate');?>" method="post">
                    <div class="form-group">
                        <label class="col-sm-4 col-lg-2 control-label"><?php echo lang_key_admin('name');?>:</label>
                        <div class="col-sm-4 col-lg-5 controls">
                            <input type="text" name="widget_name" value="" placeholder="<?php echo lang_key_admin('type_something');?>" class="form-control input-sm" >
                            <?php echo form_error("widget_name");?>
                        </div>
                    </div>
                    <div class="clearfix"></div>

                    <div class="form-group">
                        <label class="col-sm-4 col-lg-2 control-label">&nbsp;</label>
                        <div class="col-sm-4 col-lg-10 controls">
                            <label style="white-space:unset">
                            <input type="checkbox" name="use_name_as_title" value="1"> <?php echo lang_key_admin('use_name_as_frontend_widget_title');?>
                            </label>
                        </div>
                    </div>
                    <div class="clearfix"></div>
                    
                    <div class="form-group">
                        <label class="col-sm-4 col-lg-2 control-label"><?php echo lang_key_admin('type');?>:</label>
                        <div class="col-sm-4 col-lg-5 controls">
                            <select class="form-control input-sm" name="type" id="type">
                            <?php $sel = (set_value('type')=='news_source')?'selected="selected"':'';?>
                            <option value="news_source" <?php echo $sel;?>><?php echo lang_key_admin('news_source');?></option>  
                            <?php $sel = (set_value('type')=='news_category')?'selected="selected"':'';?>
                            <option value="news_category" <?php echo $sel;?>><?php echo lang_key_admin('news_category');?></option>  
                            </select>
                            <?php echo form_error('type'); ?>
                        </div>
                    </div>
                    <div class="clearfix"></div>

                    <div class="form-group news-source">
                        <label class="col-sm-4 col-lg-2 control-label"><?php echo lang_key_admin('source');?>:</label>
                        <div class="col-sm-4 col-lg-5 controls">
                            <select class="form-control input-sm" name="source_id" id="source_id">
                                <option value=""><?php echo lang_key_admin('no_source');?></option>
                                <?php
                                $v = isset($post->source_id)?$post->source_id:'';
                                $v = (set_value('source_id')!='')?set_value('source_id'):$v;
                                ?>
                                <?php
                                $CI = get_instance();
                                $CI->load->model('admin/content_model');
                                $sources = $CI->content_model->get_all_sources();
                                foreach ($sources->result() as $cat) {
                                    $sel = ($v==$cat->id)?'selected="selected"':'';
                                    ?>
                                    <option value="<?php echo $cat->id;?>" <?php echo $sel;?>><?php echo $cat->source_name;?></option>
                                <?php
                                }
                                ?>
                            </select>
                            <?php echo form_error('source_id'); ?>
                        </div>
                    </div>
                    <div class="clearfix"></div>

                    <div class="form-group news-category">
                        <label class="col-sm-4 col-lg-2 control-label"><?php echo lang_key_admin('category');?>:</label>
                        <div class="col-sm-4 col-lg-5 controls">
                            <select class="form-control input-sm" name="parent_category" id="parent_category">
                            <option value=""><?php echo lang_key_admin('select_one');?></option>
                            <?php 
                            $v = isset($post->parent_category)?$post->parent_category:'';
                            $v = (set_value('parent_category')!='')?set_value('parent_category'):$v;
                            ?>                          
                            <?php 
                            $CI = get_instance();
                            $CI->load->model('admin/category_model');
                            $categories = $CI->category_model->get_all_parent_categories_by_range();
                            foreach ($categories->result() as $cat) {
                                $sel = ($v==$cat->id)?'selected="selected"':'';
                            ?>
                            <option value="<?php echo $cat->id;?>" <?php echo $sel;?>><?php echo $cat->title;?></option>
                            <?php
                            }
                            ?>  
                        </select>
                        <?php echo form_error('parent_category'); ?>
                        </div>
                    </div>
                    <div class="clearfix"></div>


                    <!--div class="form-group">
                        <label class="col-sm-4 col-lg-2 control-label"><?php echo lang_key_admin('sub_category');?>:</label>
                        <div class="col-sm-4 col-lg-5 controls">
                            <select class="form-control input-sm" name="sub_category" id="sub_category">
                            <option value=""><?php echo lang_key_admin('select_one');?></option>  

                            </select>
                            <?php echo form_error('sub_category'); ?>
                        </div>
                    </div>
                    <div class="clearfix"></div-->

                    <div class="form-group">
                        <label class="col-sm-4 col-lg-2 control-label"><?php echo lang_key_admin('limit');?>:</label>
                        <div class="col-sm-4 col-lg-5 controls">
                            <select class="form-control input-sm" name="limit" id="limit">
                            <?php 
                            $options = array(5,10,15,20);
                            foreach ($options as $option) {
                            ?>
                            <option value="<?php echo $option;?>"><?php echo $option;?></option>
                            <?php
                            }
                            ?>
                            </select>
                            <?php echo form_error('limit'); ?>
                        </div>
                    </div>
                    <div class="clearfix"></div>

                    

                    <div class="form-group">
                        <label class="col-sm-4 col-lg-2 control-label">&nbsp;</label>
                        <div class="col-sm-4 col-lg-5 controls">
                            <button class="btn btn-primary" type="submit"><i class="fa fa-check"></i> <?php echo lang_key_admin('create');?></button>
                        </div>
                    </div>
                    <div class="clearfix"></div>
                </form>
            </div>
        </div>
    </div>
</div>


<div class="row">
    <div class="col-md-12">
        <div class="box">
            <div class="box-title">
                <h3><i class="fa fa-bars"></i> <?php echo lang_key('all_widgets');?></h3>
                <div class="box-tool">
                    <a href="javascript:void(0);" data-action="collapse"><i class="fa fa-chevron-up"></i></a>

                </div>
            </div>
            <div class="box-content">
                <div id="no-more-tables">
                    <table class="table table-hover">
                        <thead>
                        <tr>
                            <th class="numeric">#</th>
                            <th class="numeric"><?php echo lang_key('widget_name');?></th>
                            <th class="numeric"><?php echo lang_key('alias');?></th><!-- added on version 1.8 -->
                            <th class="numeric"><?php echo lang_key('activate_deactivate');?></th>
                            <th class="numeric"><?php echo lang_key('actions');?></th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php $i=1; foreach($widgets->result() as $row){?>
                        <tr>
                            <td data-title="#" class="numeric"><?php echo html_escape($i);?></td>
                            <input type="hidden" name="widget[]" value="<?php echo html_escape($row->name);?>">
                            <td data-title="<?php echo lang_key('widget_name');?>" class="numeric"><?php echo html_escape($row->name);?></td>
                            <td data-title="<?php echo lang_key('alias');?>" class="numeric"><?php echo html_escape($row->alias);?></td>
                            <td data-title="<?php echo lang_key('activate_deactivate');?>" class="numeric">
                                <?php if($row->status==1){?>
                                    <a href="<?php echo site_url('admin/widgets/setstatus/'.$row->alias.'/0');?>"  class="btn btn-sm btn-warning">Deactivate</a>
                                <?php }else{?>
                                    <a href="<?php echo site_url('admin/widgets/setstatus/'.$row->alias.'/1');?>"  class="btn btn-sm btn-success">Activate</a>
                                <?php }?>
                            </td>
                            <td data-title="<?php echo lang_key('actions');?>" class="numeric">
                                <div class="dropdown">
                                    <a class="btn btn-sm btn-info dropdown-toggle" data-toggle="dropdown" href="javascript:void(0);"><i class="fa fa-cog"></i> <?php echo lang_key('action');?> <span class="caret"></span></a>
                                    <div class="dropdown-menu" aria-labelledby="dropdownMenuButton">
                                        <a class="dropdown-item edit-widget" href="<?php echo site_url('admin/widgets/edit/'.$row->alias);?>" ><?php echo lang_key('edit');?></a>
                                        <?php if($row->editable==1){?>
                                        <a class="dropdown-item" href="<?php echo site_url('admin/widgets/setstatus/'.$row->alias.'/2');?>"><?php echo lang_key('delete');?></a>
                                        <?php }?>
                                    </div>
                                </div>
                            </td>

                        </tr>
                        <?php $i++;}?>
                        </tbody>
                        </table>
                    </div>
            </div>
        </div>
    </div>
</div>

<!-- Modal -->
<div class="modal" id="editWidgetModal">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-body">
            </div>
        </div>
    </div>
</div>
