<?php
$CI = get_instance();
$CI->load->model('show/post_model');
$parent_categories = $CI->post_model->get_all_parent_categories();
?>


<div class="row grid-box">

    <?php 
    $i = 0;
    foreach ($parent_categories->result() as $parent) 
    {
        $i++;
        $icon_class = ($i%7)+1;
    ?>
                    <!-- Category list -->
        <div class="col-lg-4 col-md-6 col-sm-6 col-12 grid-col">
            <div class="category-block">
                <div class="header">
                    <a href="<?php echo site_url('show/categorynews/'.$parent->id.'/'.dbc_url_title(lang_key($parent->title)));?>">
                        <i class="fa <?php echo html_escape($parent->fa_icon);?> icon-bg-<?php echo html_escape($icon_class);?>"></i> 
                    </a>
                    <h4>
                        <a href="<?php echo site_url('show/categorynews/'.$parent->id.'/'.dbc_url_title(lang_key($parent->title)));?>"><?php echo lang_key($parent->title);?></a> <span dir="rtl" class="category-counter">(<?php echo count_news_by_category($parent->id);?>) </span>
                    </h4>
                </div>

                <?php
                $child_categories = $CI->post_model->get_all_child_categories($parent->id, 5);
                $total = $child_categories->num_rows();
                if($total>0){
                ?>

                <ul class="category-list">
                <?php
                $j=1;
                foreach ($child_categories->result() as $child)
                {
                    if($j<=4)
                    {
                ?>                    
                    <li>
                        <a class="" title="View posts in <?php echo lang_key($child->title);?>" href="<?php echo site_url('show/categorynews/'.$child->id.'/'.dbc_url_title(lang_key($child->title)));?>">
                        <?php echo lang_key($child->title);?>
                        <span dir="rtl" class="category-counter">(<?php echo count_news_by_subcategory($child->id);?>) </span>
                        </a>                        
                    </li>
                <?php 
                    }

                     $j++;
                }
                if($total>=5)
                {
                ?>
                <li class="see_all_sub_cat_li">
                    <a class="see_all_sub_cat"  title="<?php echo lang_key('view_all');?>" href="<?php echo site_url('show/allsubcat/'.$parent->id);?>">
                        <i class="fa fa fa-ellipsis-h"></i>
                    </a>
                </li>
                <?php
                }
                ?>
                </ul>
            <?php 
            }
            ?>    
            </div>
        </div> 
    <?php 
    }
    ?>

</div>

    <div id="category-modal" class="modal">
        <div class="modal-dialog modal-md">
            <div class="modal-content">
                <div class="modal-header login-modal-header">
                    <h4 class="modal-title" id="myModalLabel">
                        <?php echo lang_key('all_sub_categories'); ?>
                    </h4>
                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                </div>

                <div class="modal-body">
                </div>

                <div class="modal-footer">
                </div>
            </div>
        </div>
    </div>