<?php 
$source_id    = 'all';
$category 	  = 'all';
$sub_category = 'all';
$limit = 5;

if($CI->uri->segment(1)!='news')
{
    echo 'This widget is not for this page';
}
else
{

$CI = get_instance();
$CI->load->model('admin/news_model');

$news_id = $CI->uri->segment(2);
$news = $CI->news_model->get_news_by_id($news_id);
if($news->num_rows()>0)
{
    $row = $news->row();
    $news_query = $CI->news_model->get_similar_news_by_category($row->category, $row->sub_category, $row->id,$limit);
}

?>
<div class="s-widget">
    <!-- Heading -->
    <h5><i class="fa fa-building color"></i>&nbsp; <?php echo lang_key('related_news');?></h5>
    <!-- Widgets Content -->
    <div class="widget-content hot-properties">
        <?php if($news_query->num_rows()<=0){?>
        <div class="alert alert-info"><?php echo lang_key('no_posts');?></div>
        <?php }else{?>
        <ul class="list-unstyled">
            <?php 
            foreach ($news_query->result() as $post) {
            ?>
            <li class="col-xs-12 col-sm-6 col-md-12 col-lg-12">
                <!-- Image -->
                <a href="<?php echo post_detail_url($post);?>">
                    <?php if($CI->session->userdata('lazyload')=='yes'){?>
                    <img class="img-responsive lazy-thumb" src="<?php echo base_url('assets/images/no-image.jpeg');?>" data-src="<?php echo resolve_mixed_url($post->media);?>" alt="<?php echo $post->title;?>" />
                    <?php }else{?>
                    <img class="img-responsive" src="<?php echo resolve_mixed_url($post->media);?>" alt="<?php echo $post->title;?>" />
                    <?php }?>
                </a>
                <!-- Heading -->
                <div class="sub-head"><a href="<?php echo post_detail_url($post);?>"><?php echo format_long_text($post->title,50);?></a></div>
                <?php
                $main_news_source = get_source_title_by_id($post->source_id);
                $main_news_source_url   = source_news_url($post->source_id,$main_news_source);
                $main_news_date_url         = date_news_url($post->publish_time);
                ?>
                <div class="sub-head-link-date">
                    <a href="<?php echo $main_news_source_url;?>"><?php echo $main_news_source;?></a> -  
                    <a href="<?php echo $main_news_date_url;?>"><?php echo translateable_date($post->publish_time);#added on version 1.4?></a>
                </div>
                <div class="clearfix"></div>
            </li>
            <?php 
            }
            ?>
        </ul>
        <?php }?>
    </div>
    <div class="clearfix"></div>
</div>
<?php
}
?>