(function($) {

    "use strict"; 
    var tab = 'trainingrecords-attachments';
    var target = $('#'+tab).attr('target');
    var bar = $('#'+tab+' > .progress > .bar');
    var percent = $('#'+tab+' > .progress > .percent');
    var progress = $('#'+tab+' > .progress');   
    $('#'+tab+' > form').ajaxForm({
        beforeSend: function() {
            progress.show();
            var percentVal = '0%';
            bar.width(percentVal)
            percent.html(percentVal);
        },
        uploadProgress: function(event, position, total, percentComplete) {
            var percentVal = percentComplete + '%';
            bar.width(percentVal)
            percent.html(percentVal);
            
        },
        success: function() {
            var percentVal = '100%';
            bar.width(percentVal)
            percent.html(percentVal);
        },
        complete: function(xhr) {
            var response = jQuery.parseJSON(xhr.responseText);
            if(response.error==0)
            {
                
                window.parent.$('#search_bg').attr("value",response.name);
                window.parent.$('#search_bg').trigger('change');
            }
            else
            {
                if(response.error=='upload_invalid_min_dimensions')
                    response.error = 'Image needs to be minimum 1024x600 px';
                var error = '<div class="alert alert-danger" style="margin-bottom:0;">'+response.error+'</div>';
                window.parent.$('#search_bg-error').html(error);
            }


            var percentVal = '0%';
            bar.width(percentVal)
            percent.html(percentVal);
            progress.hide();
            
        }
    });    
})(jQuery);